#include "rmixsliderbox.h"
#include "rmixcheckbox.h"
#include "rmixenumbox.h"
#include "rmixslider.h"

rmixSliderBox::rmixSliderBox(QWidget *parent, mixerHandle *mh, QString name) {
	m_mixer= mh;
	setParent(parent);
	setObjectName(name);
	setTitle(name.endsWith(" 0") ? name.first(name.lastIndexOf(' ')) : name);
	m_layout= new QFormLayout(this);
	m_layout->setLabelAlignment(Qt::AlignRight);
}

inline QString rmixSliderBox::chNumName(ushort ch) {
	switch(ch)
	{
	case 0: return " ";
	case 1: return " R";
	default: return ' ' + QString::number(ch);
	}
}

inline ushort rmixSliderBox::newRowPos(ctrlType_t type) {
	switch(type)
	{
	case NORMAL:
		return 0;
	case GAIN:
		return m_numCh[NORMAL];
	case MONITOR:
		return m_numCh[NORMAL] + m_numCh[GAIN];
	default: // MONGAIN
		return m_numCh[NORMAL] + m_numCh[GAIN] + m_numCh[MONITOR];
	}
}

QGridLayout *rmixSliderBox::ensureRow(ushort ch, ushort numCh, ctrlType_t type) {
	QGridLayout *lRow;
	if(ch < m_numCh[type])
		lRow= qobject_cast<QGridLayout *>(m_layout->itemAt(newRowPos(type) + ch, QFormLayout::FieldRole)->layout());
	else
	{
		QString label;
		switch(type)
		{
		case GAIN:
			label= "Preamp"+chNumName(ch);
			break;
		case MONITOR:
			label= "Out"+chNumName(ch);
			break;
		case MONGAIN:
			label= "Out preamp"+chNumName(ch);
			break;
		default:
			label= chNumName(ch);
			break;
		}
		lRow= new QGridLayout();
		ushort pos;
		switch(type)
		{
		case NORMAL:
			pos= 0;
			break;
		case GAIN:
			pos= m_numCh[NORMAL];
			break;
		case MONITOR:
			pos= m_numCh[NORMAL] + m_numCh[GAIN];
			break;
		default: // MONGAIN
			pos= m_numCh[NORMAL] + m_numCh[GAIN] + m_numCh[MONITOR];
		}
		m_layout->insertRow(pos + ch, label == " " ? " " : label.trimmed(), lRow);
		m_numCh[type]++;
	}
	return lRow;
}

void rmixSliderBox::addSlider(snd_hctl_elem_t *elem, ushort numCh, ctrlType_t type) {
	rmixSlider *w, *wprev= nullptr;
	bool needsCb=0;
	for(ushort j= 0; j < numCh; j++)
	{
		if(j >= m_numCh[type])
			needsCb=1;
		QGridLayout *lRow= ensureRow(j, numCh, type);
		QLabel *lbVal= new QLabel;
		lbVal->setAlignment(Qt::AlignRight);
		w= new rmixSlider(m_mixer->m_ctl, elem, j, lbVal, wprev);
		wprev= w;
		lRow->addWidget(w, 0, 1);
		lRow->addWidget(lbVal, 0, 2);
		if(needsCb)
		{
			QCheckBox *dummyCb= new QCheckBox(this);
			dummyCb->setDisabled(1);
			lRow->addWidget(dummyCb, 0, 0);
		}
	}
}

void rmixSliderBox::addSwitch(snd_hctl_elem_t *elem, ushort numCh, ctrlType_t type) {
	rmixCheckBox *w, *wprev= nullptr;
	for(ushort j= 0; j < numCh; j++)
	{
		QGridLayout *lRow= ensureRow(j, numCh, type);
		QLayoutItem *dummyCb= lRow->itemAtPosition(0, 0);
		if(dummyCb)
			dummyCb->widget()->setVisible(0);
		w= new rmixCheckBox(elem, j, 0, wprev);
		lRow->addWidget(w, 0, 0);
		wprev= w;
	}
}

void rmixSliderBox::addSrcSel(snd_hctl_elem_t *elem, ushort numCh) {
	rmixEnumBox *w, *wprev= nullptr;
	QHBoxLayout *lRow= new QHBoxLayout();
	lRow->addWidget(new QLabel("Input source:"));
	for(ushort j= 0; j < numCh; j++)
	{
		w= new rmixEnumBox(elem, j, wprev);
		wprev= w;
		lRow->addWidget(w);
	}
	lRow->addStretch();
	m_layout->addRow(lRow);
	snd_hctl_elem_set_callback_private(elem, new mixerHandle::callbackData{ mixerHandle::EB, w });
	snd_hctl_elem_set_callback(elem, callback);
}

void rmixSliderBox::cleanup() {
	if(m_numCh[NORMAL] > 1)
		qobject_cast<QLabel *>(m_layout->itemAt(0, QFormLayout::LabelRole)->widget())->setText(qobject_cast<QLabel *>(m_layout->itemAt(0, QFormLayout::LabelRole)->widget())->text() + " L");
	if(m_numCh[GAIN] > 1)
		qobject_cast<QLabel *>(m_layout->itemAt(m_numCh[NORMAL], QFormLayout::LabelRole)->widget())->setText(qobject_cast<QLabel *>(m_layout->itemAt(m_numCh[NORMAL], QFormLayout::LabelRole)->widget())->text() + " L");
	if(m_numCh[MONITOR] > 1)
		qobject_cast<QLabel *>(m_layout->itemAt(m_numCh[NORMAL] + m_numCh[GAIN], QFormLayout::LabelRole)->widget())->setText(qobject_cast<QLabel *>(m_layout->itemAt(m_numCh[NORMAL] + m_numCh[GAIN], QFormLayout::LabelRole)->widget())->text() + " L");
	if(m_numCh[MONGAIN] > 1)
		qobject_cast<QLabel *>(m_layout->itemAt(m_numCh[NORMAL] + m_numCh[GAIN] + m_numCh[MONITOR], QFormLayout::LabelRole)->widget())->setText(qobject_cast<QLabel *>(m_layout->itemAt(m_numCh[NORMAL] + m_numCh[GAIN] + m_numCh[MONITOR], QFormLayout::LabelRole)->widget())->text() + " L");
}
